<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reward_settings', function (Blueprint $table) {
            $table->id();
            $table->decimal('add_money_comm', 12, 2)->default(0);
            $table->decimal('send_money_comm', 12, 2)->default(0);
            $table->decimal('drive_offer_comm', 12, 2)->default(0);
            $table->decimal('mobile_recharge_comm', 12, 2)->default(0);
            $table->decimal('paybills_comm', 12, 2)->default(0);
            $table->decimal('mobile_banking_comm', 12, 2)->default(0);
            $table->decimal('bank_trans_comm', 12, 2)->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reward_settings');
    }
};
