<?php
// database/migrations/2025_01_12_000001_create_exchange_countries_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('exchange_countries', function (Blueprint $t) {
            $t->id();
            $t->string('name');                 // Qatar, Malaysia
            $t->string('slug')->unique();       // qatar, malaysia
            $t->string('currency_name');        // Rial, Ringgit
            $t->string('unit_label')->default('1'); // “1” বা “1 Rial”
            $t->decimal('rate_bdt', 10, 2);     // 38.55
            $t->string('flag_path')->nullable();// public/storage/flags/qatar.svg
            $t->string('header_bg')->nullable();// হেডার গ্রেডিয়েন্ট/রঙ (optional), উদা: #4C0519
            $t->string('share_title_bn')->nullable();
            $t->string('share_title_en')->nullable();
            $t->text('share_desc_bn')->nullable();
            $t->text('share_desc_en')->nullable();
            $t->boolean('is_active')->default(true);
            $t->unsignedInteger('position')->default(0); // সাজানোর জন্য
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('exchange_countries'); }
};
