<?php
// database/migrations/2025_01_10_000002_create_bank_transfers_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('bank_transfers', function (Blueprint $t) {
            $t->id();
            $t->foreignId('user_id')->constrained()->cascadeOnDelete();
            $t->foreignId('bank_id')->constrained('banks')->cascadeOnDelete();
            $t->string('account_name');
            $t->string('account_number');
            $t->string('branch_name')->nullable();
            $t->decimal('amount', 12, 2);
            $t->enum('status', ['pending','approved','rejected'])->default('pending');
            $t->text('admin_note')->nullable();
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('bank_transfers'); }
};
