<?php

// database/migrations/2025_01_10_000001_create_banks_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('banks', function (Blueprint $t) {
            $t->id();
            $t->string('name');
            $t->string('slug')->unique();
            $t->decimal('min_transaction', 12, 2)->default(0);
            $t->decimal('reward_percent', 5, 2)->default(0); // user reward %
            $t->boolean('is_active')->default(true);
            $t->string('logo_path')->nullable();
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('banks'); }
};
