<?php
// database/migrations/2025_01_01_000003_create_mobile_transactions_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('mobile_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('gateway_id')->constrained('mobile_gateways')->cascadeOnDelete();

            $table->string('account_number');               // যাকে পাঠালেন/যেখান থেকে নিলেন
            $table->decimal('amount', 14, 2);
            $table->enum('channel', ['agent', 'personal']); // এজেন্ট/পার্সোনাল
            $table->string('reference')->nullable();

            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');

            // কমিশন গণনা করে স্টোর করি; user.reward_points-এও যোগ হয় (approved হলে নিরাপদ)
            $table->decimal('commission_amount', 14, 2)->default(0);

            // অ্যাডমিন নোট ইত্যাদি
            $table->text('admin_note')->nullable();

            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('mobile_transactions');
    }
};
