<?php
// database/migrations/2025_01_01_000002_create_mobile_gateways_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('mobile_gateways', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();        // BKASH, NAGAD, ROCKET
            $table->decimal('min_limit', 14, 2)->default(0);
            $table->decimal('max_limit', 14, 2)->default(0);
            $table->boolean('is_active')->default(true);
            $table->string('logo_path')->nullable();

            // কমিশন কনফিগ (অ্যাডমিন সেট করবেন)
            $table->decimal('flat_fee', 14, 2)->default(0);     // স্থির ফি
            $table->decimal('percent_fee', 5, 2)->default(0);   // % (যেমন 1.5)
            $table->decimal('min_commission', 14, 2)->default(0);
            $table->decimal('max_commission', 14, 2)->default(0);

            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('mobile_gateways');
    }
};
