<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('loan_repayments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('loan_application_id')->constrained()->cascadeOnDelete();
            $table->date('due_date');
            $table->decimal('amount', 12, 2);   // প্রতি কিস্তি
            $table->timestamp('paid_at')->nullable();
            $table->enum('status', ['due','paid'])->default('due');
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('loan_repayments');
    }
};
