<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('loan_applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->unsignedBigInteger('loan_amount');
            $table->unsignedInteger('loan_period'); // months
            $table->decimal('interest_rate', 5, 2);
            $table->unsignedBigInteger('estimated_total'); // amount + interest
            $table->string('image_path')->nullable(); // /storage/...
            $table->string('status')->default('pending'); // pending|approved|rejected
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('loan_applications');
    }
};
