<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('loan_settings', function (Blueprint $table) {
            $table->id();
            $table->decimal('interest_rate', 5, 2)->default(1.00);
            $table->decimal('eligibility_min_turnover', 12, 2)->default(100000.00);
            $table->json('loan_options')->nullable();  // [50000,100000,...]
            $table->json('loan_periods')->nullable();  // [6,12,18,24]
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('loan_settings');
    }
};
