<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('billers', function (Blueprint $table) {
      $table->id();
      $table->foreignId('biller_category_id')->constrained()->cascadeOnDelete();
      $table->string('name');                       // e.g. "Palli Bidyut (Prepaid)"
      $table->string('code')->unique();            // e.g. "BIDYUT_PREPAID"
      $table->string('provider')->nullable();      // UI তে ছোট টেক্সট (e.g. BIDYUT, Gas, Water)
      $table->enum('type', ['prepaid','postpaid'])->nullable(); // UI ট্যাগ
      $table->string('logo')->nullable();          // circle icon url
      $table->decimal('min_amount', 12, 2)->default(10);
      $table->decimal('max_amount', 12, 2)->default(100000);
      $table->enum('status', ['active','inactive'])->default('active');
      $table->unsignedInteger('sort_order')->default(0);
      $table->timestamps();
    });
  }
  public function down(): void {
    Schema::dropIfExists('billers');
  }
};
