<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('biller_categories', function (Blueprint $table) {
      $table->id();
      $table->string('name');
      $table->string('slug')->unique();
      $table->string('icon')->nullable();                 // e.g. "⚡" বা কোনো ইমেজ URL
      $table->enum('status', ['active','inactive'])->default('active');
      $table->unsignedInteger('sort_order')->default(0);
      $table->timestamps();
    });
  }
  public function down(): void {
    Schema::dropIfExists('biller_categories');
  }
};
