<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('reward_conversions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->unsignedBigInteger('points');         // কত পয়েন্ট কনভার্ট হল
            $table->decimal('amount', 12, 2);             // কত টাকা হয়েছে
            $table->unsignedInteger('rate_points');       // উদাহরণ: 100
            $table->decimal('rate_amount', 12, 2);        // উদাহরণ: 1.00
            $table->string('ref')->nullable();            // রেফারেন্স/নোট (optional)
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('reward_conversions');
    }
};
