<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('deposit_packages', function (Blueprint $table) {
            $table->id();
            $table->string('title');                           // যেমন: "৫০,০০০ টাকা ডিপোজিট"
            $table->decimal('principal_amount', 12, 2);        // যেমন: 50000
            $table->decimal('bonus_percent', 5, 2)->default(0);// যেমন: 1.2 (%)
            $table->string('badge_text')->nullable();          // কার্ডের কোণায় ছোট ব্যাজ: "১.২%"
            $table->enum('status', ['active','inactive'])->default('active');
            $table->unsignedInteger('sort_order')->default(0);
            $table->timestamps();
        });

        // পেজের টেক্সট/কন্ট্যাক্ট ইনফো এডিট করার জন্য সিম্পল কিভ্যালু সেটিংস
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deposit_packages');
        Schema::dropIfExists('settings');
    }
};
