<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('recharges', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->enum('service_type', ['prepaid','postpaid'])->default('prepaid');
            $table->string('msisdn');
            $table->decimal('amount', 12, 2);
            $table->string('reference')->nullable();
            $table->enum('status', ['pending','succeeded','failed'])->default('pending');
            $table->string('txn_id')->nullable();
            $table->timestamps();
            $table->index(['user_id','status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('recharges');
    }
};
