<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('operators', function (Blueprint $table) {
            $table->id();
            $table->string('name');        
            $table->string('code')->unique(); 
            $table->string('logo')->nullable();
            $table->enum('status', ['active','inactive'])->default('active');
            $table->unsignedInteger('sort_order')->default(0);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('operators'); }
};