<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('from_user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('to_user_id')->constrained('users')->cascadeOnDelete();
            $table->decimal('amount', 12, 2);
            $table->string('note')->nullable();
            $table->string('status')->default('succeeded'); // succeeded|failed|reversed
            $table->string('idempotency_key')->nullable()->index();
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('transfers');
    }
};
