<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('name');               // e.g., "Bkash Personal"
            $table->string('logo')->nullable();               // e.g., "Bkash Personal"
            $table->string('slug')->unique();     // e.g., bkash-personal
            $table->string('type')->default('mobile_wallet');
            $table->string('account_no')->nullable();
            $table->unsignedInteger('daily_min')->nullable();
            $table->unsignedInteger('daily_max')->nullable();
            $table->boolean('is_active')->default(true);
            $table->unsignedInteger('set_reward_points_pm')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('payment_methods');
    }
};
