<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        // channels: __DIR__.'/../routes/channels.php', // যদি প্রয়োজন হয়, আনকমেন্ট করুন
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'role' => \App\Http\Middleware\EnsureUserRole::class,
            'not.blocked' => \App\Http\Middleware\EnsureUserIsNotBlocked::class,
            'pin.verified' => \App\Http\Middleware\EnsurePinVerified::class,
            'preventBack' => \App\Http\Middleware\PreventBackAfterLogin::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })
    ->create();
 