<?php

namespace App\Providers;

use App\Models\AddmoneyBank;
use App\Models\AddMoneyCardSubmit;

use App\Models\BankTransfer;
use App\Models\BillPayment;
use App\Models\Deposit;
use App\Models\LoanApplication;
use App\Models\LoanRepayment;
use App\Models\MobileTransaction;
use App\Models\Purchase;
use App\Models\Recharge;
use App\Models\RewardConversion;
use App\Models\Transfer;
use App\Observers\NotifyAdminObserver;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        foreach ([
        Deposit::class,
        Transfer::class,
        Purchase::class,
        Recharge::class,
        RewardConversion::class,
        BillPayment::class,
        LoanApplication::class,
        LoanRepayment::class,
        MobileTransaction::class,
        BankTransfer::class,
        AddmoneyBank::class,
        AddMoneyCardSubmit::class,
        
    ] as $model) {
        $model::observe(NotifyAdminObserver::class);
    }
    }
}
