<?php

namespace App\Notifications;

use App\Models\Deposit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewDepositForReview extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Deposit $deposit) {}

    public function via($notifiable) { return ['database','mail']; }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New deposit pending approval')
            ->line('User #'.$this->deposit->user_id.' submitted a deposit of '.$this->deposit->amount)
            ->action('Review', route('admin.deposits.index', $this->deposit));
    }

    public function toArray($notifiable)
    {
        return [
            'title'      => 'New deposit pending approval',
            'deposit_id' => $this->deposit->id,
            'amount'     => $this->deposit->amount,
            'reference'  => $this->deposit->reference,
        ];
    }
}
