<?php

namespace App\Notifications;

use App\Models\Deposit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DepositRejected extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Deposit $deposit) {}

    public function via($notifiable) { return ['database','mail']; }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Deposit rejected')
            ->line('Your deposit has been rejected.')
            ->line('Reason: '.$this->deposit->admin_note)
            ->action('View details', route('add-money.success', $this->deposit));
    }

    public function toArray($notifiable)
    {
        return [
            'title'      => 'Deposit rejected',
            'deposit_id' => $this->deposit->id,
            'reference'  => $this->deposit->reference,
            'amount'     => $this->deposit->amount,
            'status'     => 'rejected',
            'reason'     => $this->deposit->admin_note,
        ];
    }
}
