<?php

namespace App\Notifications;

use App\Models\Deposit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DepositApproved extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Deposit $deposit) {}

    public function via($notifiable) { return ['database','mail']; }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Deposit approved')
            ->line('Your deposit has been approved.')
            ->line('Ref: '.$this->deposit->reference)
            ->line('Amount: '.$this->deposit->amount)
            ->action('View', route('add-money.success', $this->deposit));
    }

    public function toArray($notifiable)
    {
        return [
            'title'      => 'Deposit approved',
            'deposit_id' => $this->deposit->id,
            'reference'  => $this->deposit->reference,
            'amount'     => $this->deposit->amount,
            'status'     => 'approved',
        ];
    }
}
