<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\BroadcastMessage;

class AdminActionNotification extends Notification
{
    use Queueable;

    protected string $title;
    protected string $message;
    protected array $meta;

    public function __construct(string $title, string $message, array $meta = [])
    {
        $this->title   = $title;
        $this->message = $message;
        $this->meta    = $meta;
    }

    public function via($notifiable): array
    {
        // database + broadcast
        return ['database', 'broadcast'];
    }

    public function toArray($notifiable): array
    {
        return [
            'title'   => $this->title,
            'message' => $this->message,
            'meta'    => $this->meta,
        ];
    }

    public function toBroadcast($notifiable): BroadcastMessage
    {
        return new BroadcastMessage($this->toArray($notifiable));
    }
}
