<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transfer extends Model
{
    protected $fillable = [
        'from_user_id','to_user_id','amount','note','status','idempotency_key'
    ];

    public function fromUser() { return $this->belongsTo(User::class, 'from_user_id'); }
    public function toUser()   { return $this->belongsTo(User::class, 'to_user_id'); }

    public function debitTransaction() {
        return $this->morphOne(Transaction::class, 'related')->where('type','debit');
    }
    public function creditTransaction() {
        return $this->morphOne(Transaction::class, 'related')->where('type','credit');
    }


    public function sentTransfers() { return $this->hasMany(Transfer::class,'from_user_id'); }
public function receivedTransfers() { return $this->hasMany(Transfer::class,'to_user_id'); }

}
