<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'user_id','type','amount','balance_after',
        'related_type','related_id','meta',
    ];

    protected $casts = ['meta' => 'array'];

    public function related() { return $this->morphTo(); }


    public function user() {
        return $this->belongsTo(User::class);
    }

    

    // ছোট ইউটিল: ক্রেডিট/ডেবিট ব্যাজের জন্য
    public function isCredit(): bool { return $this->type === 'credit'; }
    public function isDebit(): bool  { return $this->type === 'debit';  }

}
