<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RewardConversion extends Model
{
    protected $fillable = [
        'user_id','points','amount','rate_points','rate_amount','ref',
    ];

    protected $casts = [
        'amount'      => 'decimal:2',
        'rate_amount' => 'decimal:2',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }
}
