<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Recharge extends Model
{
    protected $fillable = [
        'user_id','service_type','msisdn','amount','reference','status','txn_id',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeSucceeded($q) { return $q->where('status','succeeded'); }
    public function scopeFailed($q)    { return $q->where('status','failed'); }
    public function scopePending($q)   { return $q->where('status','pending'); }
}
