<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    protected $fillable = [
        'user_id','offer_id','msisdn','reference','price','status','txn_id',
    ];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    public function user()   { return $this->belongsTo(User::class); }
    public function offer()  { return $this->belongsTo(Offer::class); }

    public function scopeSucceeded($q) { return $q->where('status','succeeded'); }
    public function scopePending($q)   { return $q->where('status','pending'); }
    public function scopeFailed($q)    { return $q->where('status','failed'); }
}
