<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
   protected $fillable = [
        'name', 'logo', 'slug', 'type', 'account_no',
        'daily_min', 'daily_max', 'is_active', 'meta','set_reward_points_pm'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'meta'      => 'array',
        'daily_min' => 'integer',
        'daily_max' => 'integer',
        'set_reward_points_pm' => 'integer',
        
    ];


    public function deposits() { return $this->hasMany(Deposit::class); }


    
}
