<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Operator extends Model
{
    protected $fillable = ['name','code','logo','status','sort_order'];

    /** status = active */
    public function scopeActive($q)
    {
        return $q->where('status', 'active');
    }

    /** Helper accessor for convenience */
    public function getIsActiveAttribute(): bool
    {
        return ($this->status ?? null) === 'active';
    }

    public function offers()
    {
        return $this->hasMany(Offer::class);
    }
}
