<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    protected $fillable = [
        'operator_id','title','regular_price','sale_price',
        'data_gb','minutes','validity_days','status','sort_order',
    ];

    protected $casts = [
        'regular_price' => 'decimal:2',
        'sale_price'    => 'decimal:2',
        'data_gb'       => 'integer',
        'minutes'       => 'integer',
        'validity_days' => 'integer',
        'sort_order'    => 'integer',
    ];

    public function operator()
    {
        return $this->belongsTo(Operator::class);
    }

    /** status = active */
    public function scopeActive($q)
    {
        return $q->where('status', 'active');
    }

    /** Helper for controller abort_unless */
    public function getIsActiveAttribute(): bool
    {
        return ($this->status ?? null) === 'active';
    }
}
