<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MobileTransaction extends Model
{
    protected $fillable = [
        'user_id','gateway_id','account_number','amount','channel',
        'reference','status','commission_amount','admin_note',
    ];

    public function gateway(): BelongsTo {
        return $this->belongsTo(MobileGateway::class, 'gateway_id');
    }

    public function user(): BelongsTo {
        return $this->belongsTo(User::class);
    }

    
}
