<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MobileGateway extends Model
{
    protected $fillable = [
        'name','code','min_limit','max_limit','is_active','logo_path',
        'flat_fee','percent_fee','min_commission','max_commission',
    ];

    public function transactions(): HasMany {
        return $this->hasMany(MobileTransaction::class, 'gateway_id');
    }

    public function computeCommission(float $amount): float {
        $base = $this->flat_fee + ($amount * ($this->percent_fee / 100));
        $base = max($base, (float)$this->min_commission);
        if ($this->max_commission > 0) {
            $base = min($base, (float)$this->max_commission);
        }
        // কমিশন ইউজার পাবে—reward_points এ ক্রেডিট হবে
        return round($base, 2);
    }

    // app/Models/MobileGateway.php
public function getLogoUrlAttribute(): string
{
    return $this->logo_path ? asset($this->logo_path) : asset('images/'.$this->code.'.png');
}

}
