<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LoanSetting extends Model
{
    protected $fillable = [
        'interest_rate','loan_options','loan_periods','eligibility_min_turnover'
    ];

    protected $casts = [
        'interest_rate'             => 'decimal:2',
        'loan_options'              => 'array',
        'loan_periods'              => 'array',
        'eligibility_min_turnover'  => 'decimal:2',
    ];

    public static function current(): self
    {
        return static::query()->latest('id')->first() ?? static::create([
            'interest_rate'            => 12.00,
            'loan_options'             => [5000, 10000, 20000, 50000],
            'loan_periods'             => [3, 6, 12],
            'eligibility_min_turnover' => 100000.00,
        ]);
    }
}
