<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LoanRepayment extends Model
{
    protected $fillable = ['loan_application_id','due_date','amount','paid_at','status'];
    protected $casts = [
        'amount' => 'decimal:2',
        'due_date' => 'date',
        'paid_at' => 'datetime',
    ];

    public function loan(){ return $this->belongsTo(LoanApplication::class, 'loan_application_id'); }
}
