<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LoanApplication extends Model
{
    protected $fillable = [
        'user_id','loan_amount','loan_period','interest_rate','estimated_total','image_path','status'
    ];

    protected $casts = [
        'loan_amount'     => 'integer',
        'loan_period'     => 'integer',
        'interest_rate'   => 'decimal:2',
        'estimated_total' => 'integer',
    ];

    public function user(){ return $this->belongsTo(User::class); }
    public function repayments(){ return $this->hasMany(LoanRepayment::class); }

    public function scopePending($q){ return $q->where('status','pending'); }
}
