<?php

// app/Models/ExchangeCountry.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ExchangeCountry extends Model
{
    protected $fillable = [
        'name','slug','currency_name','unit_label','rate_bdt',
        'flag_path','header_bg','share_title_bn','share_title_en',
        'share_desc_bn','share_desc_en','is_active','position'
    ];

    public function getFlagUrlAttribute(): string {
        return $this->flag_path ? asset($this->flag_path) : asset('images/flags/placeholder.svg');
    }
}
