<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DepositPackage extends Model
{
    protected $fillable = [
        'title','principal_amount','bonus_percent','badge_text','status','sort_order',
    ];

    protected $casts = [
        'principal_amount' => 'decimal:2',
        'bonus_percent'    => 'decimal:2',
        'sort_order'       => 'integer',
    ];

    // scope: active
    public function scopeActive($q) { return $q->where('status','active'); }

    // বোনাস টাকার হিসাব (প্রিন্সিপাল * বোনাস%)
    public function getBonusAmountAttribute()
    {
        return round(($this->principal_amount * ($this->bonus_percent/100)), 2);
    }

    // মোট রিটার্ন (প্রিন্সিপাল + বোনাস) — UI তে "বোনাস: X টাকা" যেমন দেখানো হয়েছে
    public function getReturnAmountAttribute()
    {
        return round($this->principal_amount + $this->bonus_amount, 2);
    }
}
