<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    protected $fillable = [
        'user_id','payment_method_id','payer_phone','amount','reference','proof_path','status','admin_note','approved_at'
    ];

    protected $casts = ['approved_at'=>'datetime'];

    public function user()   { return $this->belongsTo(User::class); }
    public function method() { return $this->belongsTo(PaymentMethod::class, 'payment_method_id'); }
}
