<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContactMessage extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['name','email','subject','whatsapp','message','status','read_at'];

    protected $casts = [
        'read_at' => 'datetime',
    ];

    // Scopes
    public function scopeStatus($q, $status)
    {   return $status ? $q->where('status', $status) : $q; }
}