<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Biller extends Model
{
    protected $fillable = [
        'biller_category_id','name','code','provider','type','logo',
        'min_amount','max_amount','status','sort_order'
    ];

    protected $casts = [
        'min_amount' => 'decimal:2',
        'max_amount' => 'decimal:2',
    ];

    public function scopeActive($q){ return $q->where('status','active'); }

    public function category(){ return $this->belongsTo(BillerCategory::class,'biller_category_id'); }
}
