<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BillPayment extends Model
{
    protected $fillable = [
        'user_id','biller_id','account_name','account_no','amount','reference','status','txn_id'
    ];

    protected $casts = ['amount'=>'decimal:2'];

    public function biller(){ return $this->belongsTo(Biller::class); }
    public function user(){ return $this->belongsTo(User::class); }
}
