<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BellNotification extends Model
{
    use HasFactory;

    // চাইলে না দিলেও চলবে, তবে clear রাখি
    protected $table = 'bell_notifications';

    // কোন কোন field mass assign করা যাবে
    protected $fillable = [
        'title',
        'user_id',
        'status',
        'type',
        'amount',
        'message',
        'read_at',
    ];

    // কিছু casting করে রাখলে কাজ সহজ হয়
    protected $casts = [
        'amount' => 'decimal:2',
        'read_at' => 'datetime',
    ];
}
