<?php
// app/Models/BankTransfer.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BankTransfer extends Model
{
    protected $fillable = [
        'user_id','bank_id','account_name','account_number','branch_name','amount','status','admin_note'
    ];

    public function user(): BelongsTo { return $this->belongsTo(User::class); }
    public function bank(): BelongsTo { return $this->belongsTo(Bank::class); }
}
