<?php

// app/Models/Bank.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Bank extends Model
{
    protected $fillable = [
        'name','slug','min_transaction','reward_percent','is_active','logo_path'
    ];

    public function transfers(): HasMany { return $this->hasMany(BankTransfer::class); }

    public function getLogoUrlAttribute(): string {
        return $this->logo_path ? asset($this->logo_path) : asset('images/bank-placeholder.svg');
    }

    public function rewardPointsFor(float $amount): int {
        return (int) round($amount * ($this->reward_percent / 100));
    }
}
