<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AddmoneyBankMethod extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'addmoney_bank_methods';

    protected $fillable = [
        'bank_name',
        'bank_logo',
        'slug',
        'account_number',
        'account_holder',
        'location',
        'daily_min',
        'daily_max',
        'is_active',
        'meta',
        'display_order',
    ];

    protected $casts = [
        'is_active'   => 'boolean',
        'meta'        => 'array',
        'daily_min'   => 'decimal:2',
        'daily_max'   => 'decimal:2',
        'display_order' => 'integer',
    ];

    // Simple scopes (optional)
    public function scopeActive($q) { return $q->where('is_active', true); }
    public function scopeOrdered($q) { return $q->orderBy('display_order'); }

     // Relations
    public function deposits()
    {
        return $this->hasMany(AddmoneyBank::class, 'addmoney_bank_method_id');
    }
}
