<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AddmoneyBank extends Model
{
    use SoftDeletes;

    protected $table = 'addmoney_banks';

    protected $fillable = [
        'user_id','addmoney_bank_method_id','sender_branch','routing_number','account_number',
        'account_holder','location','amount','reference','proof_screenshot','status',
        'admin_note','reviewed_by','approved_at','rejected_at','ip','user_agent'
    ];

    protected $casts = [
        'amount'      => 'decimal:2',
        'approved_at' => 'datetime',
        'rejected_at' => 'datetime',
    ];

    // Relations
    public function method()
    {
        return $this->belongsTo(AddmoneyBankMethod::class, 'addmoney_bank_method_id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class);
    }

    public function reviewer()
    {
        return $this->belongsTo(\App\Models\User::class, 'reviewed_by');
    }
}
