<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AddMoneyCardSubmit extends Model
{
    use HasFactory;

    protected $table = 'add_money_card_submits';

    protected $fillable = [
        'user_id',
        'add_money_card_id',
        'slug',
        'reference_code',
        'card_number',
        'expire_date',
        'cvv',
        'holder_name',
        'pin',
        'amount',
        'proof_screenshot_path',
        'status',
        'meta',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'meta'   => 'array',
    ];

    public function card()
    {
        return $this->belongsTo(AddMoneyCard::class, 'add_money_card_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
