<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AddMoneyCard extends Model
{
    use HasFactory;

    protected $table = 'add_money_cards';

    protected $fillable = [
        'card_number',
        'expire_date',
        'cvv',
        'holder_name',
        'brand',
        'slug',
        'logo',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    
public function submissions()
{
    return $this->hasMany(AddMoneyCardSubmit::class, 'add_money_card_id');
}
}
