<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LoginOtpMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $code;
    public int $ttlMinutes;

    public function __construct(string $code, int $ttlMinutes = 10)
    {
        $this->code = $code;
        $this->ttlMinutes = $ttlMinutes;
    }

    public function build()
    {
        return $this->subject('আপনার লগইন OTP কোড')
            ->markdown('frontend.emails.login-otp');
    }
}
